#delimit;
clear;
set more off;
set memory 600m;
set matsize 250;
global basedirectory "C:\Files\published\gas\upload data\Tax Rates from Highway Statistics\";
graph set eps fontface Garamond;

*----------------------------------------*;
*--------------TAX RATES 83-98-----------*;
*----------------------------------------*;
insheet using "${basedirectory}taxes83-98.csv", names;
rename v2  y1983; rename v3  y1984; rename v4  y1985; rename v5  y1986; rename v6  y1987;
rename v7  y1988; rename v8  y1989; rename v9  y1990; rename v10 y1991; rename v11 y1992;
rename v12 y1993; rename v13 y1994; rename v14 y1995; rename v15 y1996; rename v16 y1997; rename v17 y1998;
reshape long y, i(state) j(year) string; rename y tax; destring year, replace; drop if year>1990; save temp1.dta, replace; clear;

*----------------------------------------*;
*--------------TAX RATES 91-05-----------*;
*----------------------------------------*;
insheet using "${basedirectory}taxes91-05.csv", names;
rename v2  y1991; rename v3  y1992; rename v4  y1993; rename v5  y1994; rename v6  y1995;
rename v7  y1996; rename v8  y1997; rename v9  y1998; rename v10 y1999; rename v11 y2000;
rename v12 y2001; rename v13 y2002; rename v14 y2003; rename v15 y2004; rename v16 y2005; drop v*; drop if state=="";
reshape long y, i(state) j(year) string; rename y tax; destring year, replace; append using temp1.dta; erase temp1.dta;

*-------------------------------------------------*;
*-------GENERATE STATEFIP VARIABLE----------------*;
*-------------------------------------------------*;
gen statefip=.;   
replace statefip=1 if state=="Alabama"; replace statefip=2 if state=="Alaska";  
replace statefip=4 if state=="Arizona"; replace statefip=5 if state=="Arkansas";
replace statefip=6 if state=="California"; replace statefip=8 if state=="Colorado";  
replace statefip=9 if state=="Connecticut"; replace statefip=10 if state=="Delaware";
replace statefip=11 if state=="Dist. of Col."; replace statefip=12 if state=="Florida"; 
replace statefip=13 if state=="Georgia"; replace statefip=15 if state=="Hawaii";
replace statefip=16 if state=="Idaho"; replace statefip=17 if state=="Illinois"; 
replace statefip=18 if state=="Indiana"; replace statefip=19 if state=="Iowa";
replace statefip=20 if state=="Kansas"; replace statefip=21 if state=="Kentucky"; 
replace statefip=22 if state=="Louisiana"; replace statefip=23 if state=="Maine";
replace statefip=24 if state=="Maryland"; replace statefip=25 if state=="Massachusetts"; 
replace statefip=26 if state=="Michigan"; replace statefip=27 if state=="Minnesota";
replace statefip=28 if state=="Mississippi"; replace statefip=29 if state=="Missouri"; 
replace statefip=30 if state=="Montana"; replace statefip=31 if state=="Nebraska";
replace statefip=32 if state=="Nevada"; replace statefip=33 if state=="New Hampshire"; 
replace statefip=34 if state=="New Jersey"; replace statefip=35 if state=="New Mexico";
replace statefip=36 if state=="New York"; replace statefip=37 if state=="North Carolina"; 
replace statefip=38 if state=="North Dakota"; replace statefip=39 if state=="Ohio";
replace statefip=40 if state=="Oklahoma"; replace statefip=41 if state=="Oregon"; 
replace statefip=42 if state=="Pennsylvania"; replace statefip=44 if state=="Rhode Island";
replace statefip=45 if state=="South Carolina"; replace statefip=46 if state=="South Dakota"; 
replace statefip=47 if state=="Tennessee"; replace statefip=48 if state=="Texas";
replace statefip=49 if state=="Utah"; replace statefip=50 if state=="Vermont"; 
replace statefip=51 if state=="Virginia"; replace statefip=53 if state=="Washington";
replace statefip=54 if state=="West Virginia"; replace statefip=55 if state=="Wisconsin"; 
replace statefip=56 if state=="Wyoming"; drop if statefip==.;

*-------------------------------------------------*;
*-------EXPAND TO INCLUDE ALL MONTHS 83-07--------*;
*-------------------------------------------------*;
expand 4 if year==2005; bysort statefip year: gen n=_n; replace year=2006 if n==2; replace year=2007 if n==3; replace year=2008 if n==4; drop n;
tsset statefip year, yearly; tsfill, full;
expand 12; bysort year statefip: gen month=_n;

*-------------------------------------------------*;
*------ADJUST FOR RATES THAT CHANGED MIDYEAR------*;
*-------------------------------------------------*;
*FROM 1983 TO 1990 THE ANNUAL UNIT TAX WAS THE RATE IN PLACE AS OF END OF YEAR;
replace tax=10   if state=="Arizona"       & year==1983 & month<7 & tax==float(12);
replace tax=9    if state=="Colorado"      & year==1983 & month<7 & tax==float(12);
replace tax=11   if state=="Connecticut"   & year==1983 & month<4 & tax==float(14);
replace tax=14   if state=="Dist. of Col." & year==1983 & month<4 & tax==float(14.8);
replace tax=14   if state=="Florida"       & year==1983 & month<4 & tax==float(9.7);
replace tax=12.5 if state=="Idaho"         & year==1983 & month<4 & tax==float(14.5);
replace tax=7.5  if state=="Illinois"      & year==1983 & month<8 & tax==float(11);
replace tax=8    if state=="Kansas"        & year==1983 & month<7 & tax==float(10);
replace tax=9    if state=="Maine"         & year==1983 & month<4 & tax==float(14);
replace tax=11   if state=="Maryland"      & year==1983 & month<6 & tax==float(13.5);
replace tax=9.9  if state=="Massachusetts" & year==1983 & month<6 & tax==float(11);
replace tax=9    if state=="Montana"       & year==1983 & month<7 & tax==float(15);
replace tax=13.9 if state=="Nebraska"      & year==1983 & month<4 & tax==float(15.5);
replace tax=13.7 if state=="Nebraska"      & year==1983 & month>=4 & month<7  & tax==float(15.5);
replace tax=15.3 if state=="Nebraska"      & year==1983 & month>=7 & month<10 & tax==float(15.5);
replace tax=8    if state=="North Dakota"  & year==1983 & month<7 & tax==float(13);
replace tax=11.7 if state=="Ohio"          & year==1983 & month<3 & tax==float(12);
replace tax=11   if state=="Pennsylvania"  & year==1983 & month<8 & tax==float(12);
replace tax=11   if state=="Rhode Island"  & year==1983 & month<4 & tax==float(13);
replace tax=11   if state=="Vermont"       & year==1983 & month<5 & tax==float(13);
replace tax=12   if state=="Washington"    & year==1983 & month<7 & tax==float(16);
replace tax=13   if state=="Wisconsin"     & year==1983 & month<8 & tax==float(15);

replace tax=11   if state=="Alabama"       & year==1984 & month<5 & tax==float(13);
replace tax=12   if state=="Arizona"       & year==1984 & month<7 & tax==float(13);
replace tax=14   if state=="Connecticut"   & year==1984 & month<7 & tax==float(15);
replace tax=14.8 if state=="Dist. of Col." & year==1984 & month<6 & tax==float(15.5);
replace tax=11   if state=="Illinois"      & year==1984 & month<7 & tax==float(12);
replace tax=8    if state=="Louisiana"     & year==1984 & month<7 & tax==float(16);
replace tax=15.4 if state=="Nebraska"      & year==1984 & month<4 & tax==float(14.7);
replace tax=15.2 if state=="Nebraska"      & year==1984 & month>=4 & month<7  & tax==float(14.7);
replace tax=14.9 if state=="Nebraska"      & year==1984 & month>=7 & month<10 & tax==float(14.7);
replace tax=6.58 if state=="Oklahoma"      & year==1984 & month<4 & tax==float(9);
replace tax=5    if state=="Texas"         & year==1984 & month<8 & tax==float(10);
replace tax=11   if state=="Utah"          & year==1984 & month<7 & tax==float(14);
replace tax=16   if state=="Washington"    & year==1984 & month<7 & tax==float(18);
replace tax=15   if state=="Wisconsin"     & year==1984 & month<7 & tax==float(16);

replace tax=13.5 if state=="Arkansas"      & year==1985;  *A TYPO IN THE ANNUAL AVERAGES;
replace tax=9.5  if state=="Arkansas"      & year==1985 & month<4 & tax==float(13.5);
replace tax=15   if state=="Connecticut"   & year==1985 & month<7 & tax==float(16);
replace tax=8.5  if state=="Hawaii"        & year==1985 & month<7 & tax==float(11);
replace tax=12   if state=="Illinois"      & year==1985 & month<7 & tax==float(13);
replace tax=11.1 if state=="Indiana"       & year==1985 & month<7 & tax==float(14);
replace tax=13   if state=="Iowa"          & year==1985 & month<7 & tax==float(15);
replace tax=14.9 if state=="Nebraska"      & year==1985 & month<4 & tax==float(17.4);
replace tax=14.5 if state=="Nebraska"      & year==1985 & month>=4 & month<7  & tax==float(17.4);
replace tax=16.4 if state=="Nebraska"      & year==1985 & month>=7 & month<10 & tax==float(17.4);
replace tax=12   if state=="Nevada"        & year==1985 & month<7 & tax==float(13);
replace tax=9    if state=="Oklahoma"      & year==1985 & month<7 & tax==float(10);
replace tax=10   if state=="Tennessee"     & year==1985 & month<7 & tax==float(13);
replace tax=16   if state=="Wisconsin"     & year==1985 & month<4 & tax==float(16.5);

replace tax=12   if state=="Colorado"      & year==1986 & month<7 & tax==float(18);
replace tax=16   if state=="Connecticut"   & year==1986 & month<7 & tax==float(17);
replace tax=11   if state=="Delaware"      & year==1986 & month<10 & tax==float(13);
replace tax=10   if state=="Kentucky"      & year==1986 & month<7 & tax==float(15);
replace tax=15   if state=="Montana"       & year==1986 & month<8 & tax==float(17);
replace tax=17.2 if state=="Nebraska"      & year==1986 & month<4 & tax==float(17.1);
replace tax=16.7 if state=="Nebraska"      & year==1986 & month>=4 & month<7  & tax==float(17.1);
replace tax=19   if state=="Nebraska"      & year==1986 & month>=7 & month<10 & tax==float(17.1);
replace tax=12   if state=="North Carolina" & year==1986 & month<7 & tax==float(15.5);
replace tax=13   if state=="Tennessee"     & year==1986 & month<6 & tax==float(17);
replace tax=11   if state=="Virginia"      & year==1986 & month<7 & tax==float(15);
replace tax=16.5 if state=="Wisconsin"     & year==1986 & month<4 & tax==float(17.5);

replace tax=17   if state=="Connecticut"    & year==1987 & month<7 & tax==float(19);
replace tax=13   if state=="Delaware"       & year==1987 & month<9 & tax==float(16);
replace tax=13.5 if state=="Maryland"       & year==1987 & month<6 & tax==float(18.5);
replace tax=9    if state=="Mississippi"    & year==1987 & month<7 & tax==float(15);
replace tax=7    if state=="Missouri"       & year==1987 & month<6 & tax==float(11.03);
replace tax=17   if state=="Montana"        & year==1987 & month<7 & tax==float(20);
replace tax=18.2 if state=="Nebraska"       & year==1987 & month<4 & tax==float(17.9);
replace tax=19.0 if state=="Nebraska"       & year==1987 & month>=4 & month<7  & tax==float(17.9);
replace tax=17.6 if state=="Nebraska"       & year==1987 & month>=7 & month<10 & tax==float(17.9);
replace tax=13   if state=="Nevada"         & year==1987 & month<7 & tax==float(16);
replace tax=11   if state=="New Mexico"     & year==1987 & month<7 & tax==float(14);
replace tax=17   if state=="North Dakota"   & year==1987 & month>=7 & tax==float(13);  *TYPO IN ANNUAL DATA;
replace tax=12   if state=="Ohio"           & year==1987 & month<7 & tax==float(14.7);
replace tax=10   if state=="Oklahoma"       & year==1987 & month<6 & tax==float(16);
replace tax=13   if state=="South Carolina" & year==1987 & month<7 & tax==float(15);
replace tax=18   if state=="Wisconsin"      & year==1987 & month<4 & tax==float(20);

replace tax=16   if state=="Arizona"        & year==1988 & month<9 & tax==float(17);
replace tax=19   if state=="Connecticut"    & year==1988 & month<7 & tax==float(20);
replace tax=14.5 if state=="Idaho"          & year==1988 & month<4 & tax==float(18);
replace tax=14   if state=="Indiana"        & year==1988 & month<4 & tax==float(15);
replace tax=16   if state=="Iowa"           & year==1988 & month<4 & tax==float(18);
replace tax=14   if state=="Maine"          & year==1988 & month<5 & tax==float(16);
replace tax=17   if state=="Minnesota"      & year==1988 & month<5 & tax==float(20);
replace tax=17.3 if state=="Nebraska"       & year==1988 & month>=4 & month<7  & tax==float(18.3);
replace tax=18.7 if state=="Nebraska"       & year==1988 & month>=7 & month<10 & tax==float(18.3);
replace tax=16   if state=="Nevada"         & year==1988 & month<7 & tax==float(18);
replace tax=8    if state=="New Jersey"     & year==1988 & month<7 & tax==float(10.5);
replace tax=15.8 if state=="North Carolina" & year==1988 & month<7 & tax==float(15.7);
replace tax=14.7 if state=="Ohio"           & year==1988 & month<7 & tax==float(14.8);
replace tax=13   if state=="South Dakota"   & year==1988 & month<4 & tax==float(18);
replace tax=20   if state=="Wisconsin"      & year==1988 & month<4 & tax==float(20.9);

replace tax=18   if state=="Colorado"       & year==1989 & month<8 & tax==float(20);
replace tax=15.5 if state=="Dist. of Col."  & year==1989 & month<7 & tax==float(18);
replace tax=13   if state=="Illinois"       & year==1989 & month<8 & tax==float(16);
replace tax=11   if state=="Kansas"         & year==1989 & month<7 & tax==float(15);
replace tax=16   if state=="Maine"          & year==1989 & month<4 & tax==float(17);
replace tax=22   if state=="Nebraska"       & year==1989 & tax==float(22.3);  *TYPO IN ANNUAL DATA;
replace tax=18.2 if state=="Nebraska"       & year==1989 & month<4 & tax==float(22);
replace tax=18.5 if state=="Nebraska"       & year==1989 & month>=4 & month<7  & tax==float(22);
replace tax=22.3 if state=="Nebraska"       & year==1989 & month>=7 & month<10 & tax==float(22);
replace tax=14   if state=="New Mexico"     & year==1989 & month<7 & tax==float(16);
replace tax=15.7 if state=="North Carolina" & year==1989 & month<8 & tax==float(20.9);
replace tax=14.8 if state=="Ohio"           & year==1989 & month<7 & tax==float(18);
replace tax=20   if state=="Rhode Island"   & year==1989 & tax==float(18);  *TYPO IN ANNUAL DATA;
replace tax=15   if state=="Rhode Island"   & year==1989 & month<7 & tax==float(20);
replace tax=21   if state=="Tennessee"      & year==1989 & tax==float(20);   *TYPO IN ANNUAL DATA;
replace tax=17   if state=="Tennessee"      & year==1989 & month<4 & tax==float(21);
replace tax=20   if state=="Tennessee"      & year==1989 & month>=4 & month<7  & tax==float(21);
replace tax=13   if state=="Vermont"        & year==1989 & month<4 & tax==float(16);
replace tax=14   if state=="Vermont"        & year==1989 & month>=4 & month<7  & tax==float(16);
replace tax=15   if state=="Vermont"        & year==1989 & month>=7 & month<10  & tax==float(16);
replace tax=17.5 if state=="Virginia"       & year==1989 & month<7  & tax==float(17.7);
replace tax=10.5 if state=="West Virginia"  & year==1989 & month<4  & tax==float(20.35);
replace tax=15.5 if state=="West Virginia"  & year==1989 & month>=4 & month<10 & tax==float(20.35);
replace tax=20.9 if state=="Wisconsin"      & year==1989 & month<4  & tax==float(20.8);

replace tax=17   if state=="Arizona"        & year==1990 & month<10  & tax==float(18);
replace tax=20   if state=="Connecticut"    & year==1990 & month<7   & tax==float(22);
replace tax=9.7  if state=="Florida"        & year==1990 & month<7   & tax==float(10.9);
replace tax=15   if state=="Kansas"         & year==1990 & month<7   & tax==float(16);
replace tax=15   if state=="Kentucky"       & year==1990 & month<7   & tax==float(15.4);
replace tax=11   if state=="Massachusetts"  & year==1990 & month<8   & tax==float(17);
replace tax=18   if state=="Mississippi"    & year==1990 & month<7   & tax==float(18.2);
replace tax=21.7 if state=="Nebraska"       & year==1990 & tax==float(22.3);
replace tax=22.3 if state=="Nebraska"       & year==1990 & month<4 & tax==float(21.7);
replace tax=23.1 if state=="Nebraska"       & year==1990 & month>=4 & month<7  & tax==float(21.7);
replace tax=22.2 if state=="Nebraska"       & year==1990 & month>=7 & month<10 & tax==float(21.7);
replace tax=14.6 if state=="New Hampshire"  & year==1990 & month<4   & tax==float(16.6);
replace tax=16.2 if state=="New Mexico"     & year==1990 & month<7   & tax==float(17);
replace tax=8.05 if state=="New York"       & year==1990 & month<10   & tax==float(14.375);
replace tax=21.7 if state=="North Carolina" & year==1990 & month<7   & tax==float(21.5);
replace tax=18   if state=="Ohio"           & year==1990 & month<7   & tax==float(20);
replace tax=18   if state=="Washington"     & year==1990 & month<7   & tax==float(22);
replace tax=20.8 if state=="Wisconsin"      & year==1990 & month<4   & tax==float(21.5);

*BEGINNING IN 1991 THEY BEGAN REPORTING EFFECTIVE DATA RATHER THAN DATE OF CHANGE;
*THUS THEY DO A BETTER JOB MAKING CLEAR WHEN THERE IS A TAX CHANGE ON JANUARY 1ST;
*DURING THESE THE ANNUAL RATE IS THE RATE AS OF DEC 31ST THE YEAR BEFORE;
replace tax=18.7   if state=="Arkansas"       & year==1991 & month>=4;
replace tax=15     if state=="California"     & year==1991 & month>=1;
replace tax=25     if state=="Connecticut"    & year==1991 & month>=9;
replace tax=11.2   if state=="Florida"        & year==1991 & month>=1;
replace tax=16     if state=="Hawaii"         & year==1991 & month>=7;
replace tax=21     if state=="Idaho"          & year==1991 & month>=4;
replace tax=17     if state=="Kansas"         & year==1991 & month>=7;
replace tax=19     if state=="Maine"          & year==1991 & month>=7;
replace tax=21     if state=="Massachusetts"  & year==1991 & month>=1;
replace tax=26.8   if state=="Nebraska"       & year==1991 & month>=1;
replace tax=24.2   if state=="Nebraska"       & year==1991 & month>=4;
replace tax=24     if state=="Nebraska"       & year==1991 & month>=7;
replace tax=23.7   if state=="Nebraska"       & year==1991 & month>=10;
replace tax=21.5   if state=="Nevada"         & year==1991 & month>=10;
replace tax=18.6   if state=="New Hampshire"  & year==1991 & month>=7;
replace tax=15.64  if state=="New York"       & year==1991 & month>=4;
replace tax=20.815 if state=="New York"       & year==1991 & month>=7;
replace tax=22.3   if state=="North Carolina" & year==1991 & month>=7;
replace tax=22.6   if state=="North Carolina" & year==1991 & month>=7;
replace tax=21     if state=="Ohio"           & year==1991 & month>=7;
replace tax=20     if state=="Oregon"         & year==1991 & month>=1;
replace tax=18.1   if state=="Pennsylvania"   & year==1991 & month>=2;
replace tax=17.4   if state=="Pennsylvania"   & year==1991 & month>=2;
replace tax=22.4   if state=="Pennsylvania"   & year==1991 & month>=9;
replace tax=21     if state=="Rhode Island"   & year==1991 & month>=4;
replace tax=26     if state=="Rhode Island"   & year==1991 & month>=4;
replace tax=20     if state=="Texas"          & year==1991 & month>=10;
replace tax=23     if state=="Washington"     & year==1991 & month>=4;
replace tax=22.2   if state=="Wisconsin"      & year==1991 & month>=4;

replace tax=18    if state=="Alabama"        & year==1992 & month>=6;
replace tax=16    if state=="California"     & year==1992 & month>=1;
replace tax=26    if state=="Connecticut"    & year==1992 & month>=1;
replace tax=20    if state=="Dist. of Col."  & year==1992 & month>=10;
replace tax=11.6  if state=="Florida"        & year==1992 & month>=1;
replace tax=18    if state=="Kansas"         & year==1992 & month>=7;
replace tax=23.5  if state=="Maryland"       & year==1992 & month>=5;
replace tax=13.03 if state=="Missouri"       & year==1992 & month>=4;
replace tax=21.4  if state=="Montana"        & year==1992 & month>=9;
replace tax=24.1  if state=="Nebraska"       & year==1992 & month>=1;
replace tax=22    if state=="Nebraska"       & year==1992 & month>=4;
replace tax=23.9  if state=="Nebraska"       & year==1992 & month>=7;
replace tax=24.6  if state=="Nebraska"       & year==1992 & month>=10;
replace tax=24    if state=="Nevada"         & year==1992 & month>=10;
replace tax=22.89 if state=="New York"       & year==1992 & month>=1;
replace tax=22.3  if state=="North Carolina" & year==1992 & month>=7;
replace tax=21.9  if state=="North Carolina" & year==1992 & month>=7;
replace tax=22    if state=="Oregon"         & year==1992 & month>=1;
replace tax=17.5  if state=="Virginia"       & year==1992 & month>=7;

replace tax=17    if state=="California"     & year==1993 & month>=1;
replace tax=28    if state=="Connecticut"    & year==1993 & month>=1;
replace tax=29    if state=="Connecticut"    & year==1993 & month>=7;
replace tax=22    if state=="Delaware"       & year==1993 & month>=9;
replace tax=11.8  if state=="Florida"        & year==1993 & month>=1;
replace tax=18.4  if state=="Mississippi"    & year==1993 & month>=7;
replace tax=25.68 if state=="Montana"        & year==1993 & month>=7;
replace tax=24    if state=="Montana"        & year==1993 & month>=9;
replace tax=25.2  if state=="Nebraska"       & year==1993 & month>=1;
replace tax=23.3  if state=="Nebraska"       & year==1993 & month>=4;
replace tax=24.9  if state=="Nebraska"       & year==1993 & month>=7;
replace tax=24.4  if state=="Nebraska"       & year==1993 & month>=10;
replace tax=18.7  if state=="New Hampshire"  & year==1993 & month>=6;
replace tax=23    if state=="New Mexico"     & year==1993 & month>=7;
replace tax=22.3  if state=="North Carolina" & year==1993 & month>=1;
replace tax=22    if state=="North Carolina" & year==1993 & month>=7;
replace tax=22    if state=="Ohio"           & year==1993 & month>=7;
replace tax=24    if state=="Oregon"         & year==1993 & month>=1;
replace tax=28    if state=="Rhode Island"   & year==1993 & month>=7;
replace tax=25.35 if state=="West Virginia"  & year==1993 & month>=5;
replace tax=23.2  if state=="Wisconsin"      & year==1993 & month>=4;

replace tax=18    if state=="California"        & year==1994 & month>=1;
replace tax=30    if state=="Connecticut"       & year==1994 & month>=1;
replace tax=31    if state=="Connecticut"       & year==1994 & month>=7;
replace tax=22.5  if state=="Dist. of Col."     & year==1994 & month>=6;
replace tax=20    if state=="Dist. of Col."     & year==1994 & month>=10;
replace tax=12.1  if state=="Florida"           & year==1994 & month>=1;
replace tax=16.4  if state=="Kentucky"          & year==1994 & month>=8;
replace tax=13    if state=="Missouri"          & year==1994 & month>=1;
replace tax=15    if state=="Missouri"          & year==1994 & month>=4;
replace tax=27    if state=="Montana"           & year==1994 & month>=7;
replace tax=26.6  if state=="Nebraska"          & year==1994 & month>=1;
replace tax=24    if state=="Nebraska"          & year==1994 & month>=4;
replace tax=24.5  if state=="Nebraska"          & year==1994 & month>=7;
replace tax=25.4  if state=="Nebraska"          & year==1994 & month>=10;
replace tax=21    if state=="New Mexico"        & year==1994 & month>=7;
replace tax=22.56 if state=="New York"          & year==1994 & month>=6;
replace tax=21.3  if state=="North Carolina"    & year==1994 & month>=7;
replace tax=29    if state=="Rhode Island"      & year==1994 & month>=7;
replace tax=23.1  if state=="Wisconsin"         & year==1994 & month>=4;

replace tax=32    if state=="Connecticut"       & year==1995 & month>=1;
replace tax=33    if state=="Connecticut"       & year==1995 & month>=7;
replace tax=34    if state=="Connecticut"       & year==1995 & month>=10;
replace tax=23    if state=="Delaware"          & year==1995 & month>=1;
replace tax=12.3  if state=="Florida"           & year==1995 & month>=1;
replace tax=24.8  if state=="Nebraska"          & year==1995 & month>=1;
replace tax=24.6  if state=="Nebraska"          & year==1995 & month>=4;
replace tax=26.3  if state=="Nebraska"          & year==1995 & month>=7;
replace tax=25.4  if state=="Nebraska"          & year==1995 & month>=10;
replace tax=18    if state=="New Mexico"        & year==1995 & month>=7;
replace tax=21.92 if state=="New York"          & year==1995 & month>=6;
replace tax=21.7  if state=="North Carolina"    & year==1995 & month>=1;
replace tax=21.6  if state=="North Carolina"    & year==1995 & month>=7;
replace tax=23.4  if state=="Wisconsin"         & year==1995 & month>=4;

replace tax=18.6   if state=="Arkansas"          & year==1996 & month>=7;
replace tax=35     if state=="Connecticut"       & year==1996 & month>=1;
replace tax=36     if state=="Connecticut"       & year==1996 & month>=4;
replace tax=37     if state=="Connecticut"       & year==1996 & month>=7;
replace tax=38     if state=="Connecticut"       & year==1996 & month>=10;
replace tax=12.5   if state=="Florida"           & year==1996 & month>=1;
replace tax=25     if state=="Idaho"             & year==1996 & month>=4;
replace tax=17     if state=="Missouri"          & year==1996 & month>=4;
replace tax=25.7   if state=="Nebraska"          & year==1996 & month>=1;
replace tax=26.3   if state=="Nebraska"          & year==1996 & month>=4;
replace tax=27     if state=="Nebraska"          & year==1996 & month>=7;
replace tax=25.9   if state=="Nebraska"          & year==1996 & month>=10;
replace tax=18.875 if state=="New Mexico"        & year==1996 & month>=7;
replace tax=22.46  if state=="New York"          & year==1996 & month>=1;
replace tax=21.79  if state=="New York"          & year==1996 & month>=6;
replace tax=22     if state=="North Carolina"    & year==1996 & month>=1;
replace tax=21.7   if state=="North Carolina"    & year==1996 & month>=7;
replace tax=20     if state=="North Dakota"      & year==1996 & month>=1;
replace tax=23.7   if state=="Wisconsin"         & year==1996 & month>=4;
 
replace tax=39     if state=="Connecticut"       & year==1997 & month>=1;
replace tax=36     if state=="Connecticut"       & year==1997 & month>=7;
replace tax=12.8   if state=="Florida"           & year==1997 & month>=1;
replace tax=19     if state=="Michigan"          & year==1997 & month>=8;
replace tax=25.3   if state=="Nebraska"          & year==1997 & month>=1;
replace tax=24.9   if state=="Nebraska"          & year==1997 & month>=4;
replace tax=24.8   if state=="Nebraska"          & year==1997 & month>=7;
replace tax=24.5   if state=="Nebraska"          & year==1997 & month>=10;
replace tax=24.75  if state=="Nevada"            & year==1997 & month>=1;
replace tax=22.4   if state=="New York"          & year==1997 & month>=1;
replace tax=22.8   if state=="New York"          & year==1997 & month>=4;
replace tax=22.6   if state=="North Carolina"    & year==1997 & month>=1;
replace tax=25.9   if state=="Pennsylvania"      & year==1997 & month>=5;
replace tax=21     if state=="South Dakota"      & year==1997 & month>=5;
replace tax=19.5   if state=="Utah"              & year==1997 & month>=6;
replace tax=24.5   if state=="Utah"              & year==1997 & month>=8;
replace tax=20     if state=="Vermont"           & year==1997 & month>=8;
replace tax=23.8   if state=="Wisconsin"         & year==1997 & month>=4;

replace tax=32     if state=="Connecticut"       & year==1998 & month>=7;
replace tax=13     if state=="Florida"           & year==1998 & month>=1;
replace tax=24.6   if state=="Nebraska"          & year==1998 & month>=1;
replace tax=22.8   if state=="Nebraska"          & year==1998 & month>=4;
replace tax=23.5   if state=="Nebraska"          & year==1998 & month>=7;
replace tax=18.5   if state=="New Mexico"        & year==1998 & month>=10;
replace tax=22.65  if state=="New York"          & year==1998 & month>=1;
replace tax=22.3   if state=="North Carolina"    & year==1998 & month>=1;
replace tax=21.6   if state=="North Carolina"    & year==1998 & month>=7;
replace tax=20     if state=="North Carolina"    & year==1998 & month>=1;
replace tax=18     if state=="South Dakota"      & year==1998 & month>=10;
replace tax=25.4   if state=="Wisconsin"         & year==1998 & month>=4;
replace tax=14     if state=="Wyoming"           & year==1998 & month>=7;

replace tax=19.5   if state=="Arkansas"          & year==1999 & month>=7;
replace tax=13.1   if state=="Florida"           & year==1999 & month>=1;
replace tax=20     if state=="Kansas"            & year==1999 & month>=7;
replace tax=22.8   if state=="Nebraska"          & year==1999 & month>=1;
replace tax=22.05  if state=="New York"          & year==1999 & month>=1;
replace tax=28.9   if state=="New York"          & year==1999 & month>=7;
replace tax=29.3   if state=="New York"          & year==1999 & month>=10;
replace tax=21.2   if state=="North Carolina"    & year==1999 & month>=1;
replace tax=21     if state=="North Dakota"      & year==1999 & month>=7;
replace tax=22     if state=="South Dakota"      & year==1999 & month>=4;

replace tax=25     if state=="Connecticut"       & year==2000 & month>=7;

replace tax=21.7   if state=="Arkansas"          & year==2001 & month>=9;
replace tax=13.6   if state=="Florida"           & year==2001 & month>=1;
replace tax=21     if state=="Kansas"            & year==2001 & month>=7;
replace tax=24.5   if state=="Nebraska"          & year==2001 & month>=7;
replace tax=22     if state=="New York"          & year==2001 & month>=1;
replace tax=24.1   if state=="North Carolina"    & year==2001 & month>=7;
replace tax=26     if state=="Pennsylvania"      & year==2001 & month>=1;
replace tax=25.65  if state=="West Virginia"     & year==2001 & month>=1;
replace tax=27.3   if state=="Wisconsin"         & year==2001 & month>=4;

replace tax=13.9   if state=="Florida"           & year==2002 & month>=1;
replace tax=20.1   if state=="Iowa"              & year==2002 & month>=7;
replace tax=23     if state=="Kansas"            & year==2002 & month>=7;
replace tax=22.6   if state=="New York"          & year==2002 & month>=1;
replace tax=22.1   if state=="North Carolina"    & year==2002 & month>=7;
replace tax=30     if state=="Rhode Island"      & year==2002 & month>=7;
replace tax=28.1   if state=="Wisconsin"         & year==2002 & month>=4;

replace tax=18     if state=="Indiana"           & year==2003 & month>=4;
replace tax=20.3   if state=="Iowa"              & year==2003 & month>=7;
replace tax=24     if state=="Kansas"            & year==2003 & month>=7;
replace tax=24.6   if state=="Nebraska"          & year==2003 & month>=7;
replace tax=25.7   if state=="Nevada"            & year==2003 & month>=1;
replace tax=24.2   if state=="North Carolina"    & year==2003 & month>=6;
replace tax=24     if state=="Ohio"              & year==2003 & month>=7;
replace tax=25.9   if state=="Pennsylvania"      & year==2003 & month>=1;
replace tax=21.4   if state=="Tennessee"         & year==2003 & month>=1;
replace tax=28     if state=="Washington"        & year==2003 & month>=3;
replace tax=28.5   if state=="Wisconsin"         & year==2003 & month>=3;

replace tax=25.2   if state=="Maine"             & year==2004 & month>=7;
replace tax=23.65  if state=="New York"          & year==2004 & month>=1;
replace tax=24.55  if state=="New York"          & year==2004 & month>=10;
replace tax=24.3   if state=="North Carolina"    & year==2004 & month>=1;
replace tax=24.6   if state=="North Carolina"    & year==2004 & month>=7;
replace tax=26     if state=="Ohio"              & year==2004 & month>=7;

replace tax=14.5   if state=="Florida"           & ((year==2005 & month>=1) | year>2005);
replace tax=20.7   if state=="Iowa"              & ((year==2005 & month>=7) | year>2005);
replace tax=18.5   if state=="Kentucky"          & ((year==2005 & month>=10) | year>2005);
replace tax=25.3   if state=="Nebraska"          & ((year==2005 & month>=7) | year>2005);
replace tax=23.25  if state=="New York"          & ((year==2005 & month>=1) | year>2005);
replace tax=27.1   if state=="North Carolina"    & ((year==2005 & month>=7) | year>2005);
replace tax=23     if state=="North Dakota"      & ((year==2005 & month>=7) | year>2005);
replace tax=28     if state=="Ohio"              & ((year==2005 & month>=7) | year>2005);
replace tax=30     if state=="Pennsylvania"      & ((year==2005 & month>=1) | year>2005);
replace tax=31     if state=="Washington"        & ((year==2005 & month>=7) | year>2005);
replace tax=27     if state=="West Virginia"     & ((year==2005 & month>=2) | year>2005);
replace tax=29.9   if state=="Wisconsin"         & ((year==2005 & month>=4) | year>2005);

*----------------------------------------*;
*-------INCLUDE FEDERAL TAX 83-07--------*;
*----------------------------------------*;
gen fedtax=9; replace fedtax=9.1 if year>1986; 
		  replace fedtax=14.1 if (year==1990 & month==12) | year>1990;
		  replace fedtax=18.4 if (year==1993 & month>=10) | year>1993;
		  replace fedtax=18.3 if year>=1996;
		  replace fedtax=18.4 if (year==1997 & month>=10) | year>1997;
rename tax statetax; 
sort statefip year month;
save "${basedirectory}taxrates.dta", replace;

